/*
 * Decompiled with CFR 0.152.
 */
package frc.util;

import frc.emul.util.Utils;
import frc.emul.vectrex.ui.config.UIGameSelector;
import frc.util.BytesArrayOutputStream;
import frc.util.IStream;
import frc.util.Unzip;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IStreamFactory {
    private static final boolean DEBUG = true;

    public static final IStream create(String string) {
        return IStreamFactory.create(Utils.getFile(string));
    }

    public static final IStream create(File file) {
        return new FileIS(file);
    }

    public static final IStream create(String string, byte[] byArray) {
        return new DataIS(string, byArray);
    }

    public static final IStream create(String string, byte[] byArray, int n, byte by) {
        if (byArray.length < n) {
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            Arrays.fill(byArray2, byArray.length, n, by);
            byArray = byArray2;
        }
        return new DataIS(string, byArray);
    }

    public static final IStream create(File file, String string) {
        return new ZipIS(file, string);
    }

    public static final IStream create(IStream iStream, int n, byte by) {
        return new PaddedIS(iStream, n, by);
    }

    public static final IStream mergeBanks(String string, List<IStream> list, byte by) {
        return new BankedIS(string, list, by);
    }

    public static final IStream compose(String string, IStream ... iStreamArray) {
        return new CompoundIS(string, iStreamArray);
    }

    public static final IStream create(String string, InputStream inputStream) throws IOException {
        return IStreamFactory.create(string, IStreamFactory.readFullContent(inputStream));
    }

    public static final int readContent(InputStream inputStream, byte[] byArray) throws IOException {
        try {
            int n;
            int n2 = byArray.length;
            int n3 = 0;
            while ((n = inputStream.read(byArray, byArray.length - n2, n2)) >= 0) {
                n2 -= n;
                n3 += n;
            }
            int n4 = n3;
            return n4;
        }
        finally {
            inputStream.close();
        }
    }

    public static final int readFullContent(InputStream inputStream, byte[] byArray, int n) throws IOException {
        try {
            byte[] byArray2;
            int n2;
            int n3 = n;
            while ((n2 = inputStream.read(byArray, n3, byArray.length - n3)) >= 0) {
                if (byArray.length == (n3 += n2)) break;
            }
            if ((byArray2 = IStreamFactory.read(byArray, n, n2 = n3 - n)) != byArray) {
                n2 = byArray2.length;
                System.arraycopy(byArray2, 0, byArray, n, n2);
            }
            int n4 = n2;
            return n4;
        }
        finally {
            inputStream.close();
        }
    }

    public static final byte[] readFullContent(InputStream inputStream) throws IOException {
        try {
            BytesArrayOutputStream bytesArrayOutputStream = new BytesArrayOutputStream(inputStream.available());
            IStreamFactory.copyContent(inputStream, bytesArrayOutputStream);
            byte[] byArray = IStreamFactory.read(bytesArrayOutputStream.getCurrentContent(), 0, bytesArrayOutputStream.size());
            return byArray;
        }
        finally {
            inputStream.close();
        }
    }

    public static final void copyContent(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
    }

    private static final String guessStreamName(String string) {
        try {
            return new File(string).getName();
        }
        catch (Exception exception) {
            return string;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isValid(IStream iStream) {
        boolean bl;
        FileInputStream fileInputStream = null;
        if (!(iStream instanceof FileIS)) return true;
        fileInputStream = new FileInputStream(((FileIS)iStream).file);
        boolean bl2 = bl = Utils.readNext(fileInputStream) - 38885514 != 0;
        if (fileInputStream == null) return bl;
        try {
            ((InputStream)fileInputStream).close();
            return bl;
        }
        catch (Exception exception) {}
        return bl;
        catch (Exception exception) {
            try {
                if (fileInputStream == null) return true;
            }
            catch (Throwable throwable) {
                if (fileInputStream == null) throw throwable;
                try {
                    ((InputStream)fileInputStream).close();
                    throw throwable;
                }
                catch (Exception exception2) {}
                throw throwable;
            }
            try {
                ((InputStream)fileInputStream).close();
                return true;
            }
            catch (Exception exception3) {}
            return true;
        }
    }

    public static final byte[] read(byte[] byArray, int n, int n2) {
        try {
            if (((byArray[n + 5] << 9 | byArray[n + 3]) << 9 | byArray[n + 1]) << 1 == 40454316) {
                GZIPInputStream gZIPInputStream = new GZIPInputStream((InputStream)new ByteArrayInputStream(IStreamFactory.escape(byArray, n + 16, (int)Utils.readLong(byArray, n + 11, 2), (int)Utils.readLong(byArray, n + 7, 4))), 8192);
                byte[] byArray2 = IStreamFactory.consume(gZIPInputStream, new byte[n2], 0, 13);
                n2 = (int)Utils.readLong(byArray2, 10, 3);
                if (Utils.readNext(gZIPInputStream) == 38885514) {
                    byArray = IStreamFactory.consume(gZIPInputStream, n2 == byArray2.length ? byArray2 : new byte[n2], 0, n2);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byArray;
    }

    public static byte[] escape(byte[] byArray, int n, int n2, int n3) {
        byte[] byArray2 = new byte[n2];
        while (n2-- > 0) {
            byArray2[n2] = (byte)(byArray[n2 + n] ^ 0x7E ^ 19 * ~n2 ^ n3);
            n3 = ~(n3 << 5 | n3 >> 27 & 0x3F);
        }
        return byArray2;
    }

    public static byte[] consume(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 >= 0 && n2 > 0) {
            n3 = inputStream.read(byArray, n, n2);
            n2 -= n3;
            n += n3;
        }
        return byArray;
    }

    static abstract class AbstractStream
    implements IStream {
        AbstractStream() {
        }

        public int copy(byte[] byArray, int n) throws IOException {
            byte[] byArray2 = this.read();
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
            return byArray2.length;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BankedIS
    extends AbstractStream {
        private final String name;
        private final List<IStream> banks;
        private final byte padByte;
        private byte[] data;

        private BankedIS(String string, List<IStream> list, byte by) {
            this.banks = list;
            this.name = string;
            this.padByte = by;
        }

        @Override
        public String getPath() {
            return this.name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getStreamName() {
            return IStreamFactory.guessStreamName(this.name);
        }

        @Override
        public int getLength() {
            return this.banks.size() * 32 * 1024;
        }

        @Override
        public InputStream open() throws IOException {
            byte[] byArray = this.read();
            return new ByteArrayInputStream(byArray);
        }

        @Override
        public byte[] read() throws IOException {
            if (this.data == null) {
                this.data = new byte[this.getLength()];
                int n = 0;
                while (n < this.banks.size()) {
                    int n2 = n * 32768;
                    int n3 = this.banks.get(n).copy(this.data, n2);
                    if (n3 < 32768) {
                        Arrays.fill(this.data, n2 + n3, n2 + 32768, this.padByte);
                    }
                    ++n;
                }
            }
            return this.data;
        }
    }

    private static class CompoundIS
    extends AbstractStream {
        private final String name;
        private final IStream[] parts;
        private int len = -1;
        private byte[] data;

        private CompoundIS(String string, IStream ... iStreamArray) {
            this.parts = iStreamArray;
            this.name = string;
        }

        public String getPath() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public String getStreamName() {
            return this.name;
        }

        public int getLength() throws IOException {
            if (this.len < 0) {
                this.len = 0;
                int n = this.parts.length;
                while (n-- > 0) {
                    this.len += this.parts[n].getLength();
                }
            }
            return this.len;
        }

        public InputStream open() throws IOException {
            byte[] byArray = this.read();
            return new ByteArrayInputStream(byArray);
        }

        public byte[] read() throws IOException {
            if (this.data == null) {
                byte[] byArray = new byte[this.getLength()];
                this.copy(byArray, 0);
                this.data = byArray;
            }
            return this.data;
        }

        public int copy(byte[] byArray, int n) throws IOException {
            if (this.data == null) {
                int n2 = 0;
                int n3 = 0;
                while (n3 < this.parts.length) {
                    n2 += this.parts[n3].copy(byArray, n + n2);
                    ++n3;
                }
                this.len = n2;
                return n2;
            }
            return super.copy(byArray, n);
        }
    }

    private static class DataIS
    extends AbstractStream {
        private final String name;
        private final byte[] data;

        private DataIS(String string, byte[] byArray) {
            this.name = string;
            this.data = byArray;
        }

        public String getPath() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public String getStreamName() {
            return IStreamFactory.guessStreamName(this.name);
        }

        public int getLength() {
            return this.data.length;
        }

        public InputStream open() throws IOException {
            return new ByteArrayInputStream(this.data);
        }

        public byte[] read() {
            return this.data;
        }
    }

    private static class FileIS
    extends AbstractStream {
        protected final File file;
        protected Integer length;

        protected FileIS(File file) {
            this.file = file;
        }

        public String getPath() {
            return Utils.getAbsolutePath(this.file).replace('\\', '/');
        }

        public String getName() {
            return Utils.getRelativePath(this.file).replace('\\', '/');
        }

        public String getStreamName() {
            return this.file.getName();
        }

        public int getLength() throws IOException {
            if (this.length == null) {
                this.length = new Integer((int)UIGameSelector.getRomFileSize(this.file));
            }
            return this.length;
        }

        public InputStream open() throws IOException {
            return new ByteArrayInputStream(this.read());
        }

        public byte[] read() throws IOException {
            return IStreamFactory.readFullContent(new FileInputStream(this.file));
        }

        public int copy(byte[] byArray, int n) throws IOException {
            return IStreamFactory.readFullContent(new FileInputStream(this.file), byArray, n);
        }
    }

    private static class PaddedIS
    extends AbstractStream {
        private final IStream source;
        private final byte padByte;
        private final int padSize;
        private byte[] padded;

        private PaddedIS(IStream iStream, int n, byte by) {
            this.source = iStream;
            this.padByte = by;
            this.padSize = n;
        }

        public String getPath() {
            return this.source.getPath();
        }

        public String getName() {
            return this.source.getName();
        }

        public String getStreamName() {
            return this.source.getStreamName();
        }

        public int getLength() throws IOException {
            return Math.max(this.source.getLength(), this.padSize);
        }

        public InputStream open() throws IOException {
            return this.source.getLength() >= this.padSize ? this.source.open() : new ByteArrayInputStream(this.read());
        }

        public byte[] read() throws IOException {
            if (this.padded == null) {
                if (this.source.getLength() >= this.padSize) {
                    this.padded = this.source.read();
                } else {
                    this.padded = new byte[this.padSize];
                    int n = this.source.copy(this.padded, 0);
                    IStreamFactory.readFullContent(this.source.open(), this.padded, 0);
                    Arrays.fill(this.padded, n, this.padded.length, this.padByte);
                }
            }
            return this.padded;
        }
    }

    private static class ZipIS
    extends FileIS {
        private final String entry;
        private boolean opened;
        private byte[] data = new byte[0];

        private ZipIS(File file, String string) {
            super(file);
            this.entry = string.replace('\\', '/');
        }

        public String getPath() {
            return String.valueOf(super.getPath()) + "/" + this.entry;
        }

        public String getName() {
            return String.valueOf(super.getName()) + "/" + this.entry;
        }

        public String getStreamName() {
            return new File(this.entry).getName();
        }

        public int getLength() throws IOException {
            return this.read().length;
        }

        public InputStream open() throws IOException {
            byte[] byArray = this.read();
            return new ByteArrayInputStream(byArray);
        }

        public byte[] read() throws IOException {
            if (!this.opened) {
                this.data = Unzip.extractBytes(this.file, this.entry, false);
                this.opened = true;
            }
            return this.data;
        }

        public int copy(byte[] byArray, int n) throws IOException {
            byte[] byArray2 = this.read();
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
            return byArray2.length;
        }
    }
}

